// this is an effect template. use it to start writing your own effects.

// -------------------------------------------------------------------------------------------------------------------------------------
// PARAMETERS:
// -------------------------------------------------------------------------------------------------------------------------------------

//transforms
float4x4 tW: WORLD;        //the models world matrix
float4x4 tWV: WORLDVIEW;        //the models world matrix
float4x4 tV: VIEW;         //view matrix as set via Renderer (DX9)
float4x4 tP: PROJECTION;   //projection matrix as set via Renderer (DX9)
float4x4 tWVP: WORLDVIEWPROJECTION;


//texture
texture Tex <string uiname="Texture";>;
float4x4 tTex <string uiname="Texture Transform";>;

                 //Texture Transform
float4x4 RCtoTC =
(
 0.5,  0.0,  0.0,  0.0,
 0.0, -0.5,  0.0,  0.0,
 0.0,  0.0,  1.0,  0.0,
 0.5,  0.5,  0.0,  1.0
);


float LodBias = -1;
float Dist <string uiname="Far Plane";> = 5;

float Alpha = 1;



//tTex = mul ( tTex , RCtoTC );
sampler Samp = sampler_state    //sampler for doing the texture-lookup
{
    Texture   = (Tex);          //apply a texture to the sampler
    MipFilter = LINEAR;         //set the sampler states
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    // BorderColor = { 1.0, .0, 1.0, .0 }; // what to do with border color? alpha does not respond ...
    AddressU = Border;           /////////
    AddressV = Border;           /////////  vorher Clamp, so ein Quatsch
    MipMapLodBias = (LodBias);
};


// -------------------------------------------------------------------------------------------------------------------------------------
// VERTEXSHADERS
// -------------------------------------------------------------------------------------------------------------------------------------


struct VS_OUTPUT
{
    float4 PosWVP  : POSITION;
    float4 TexC : TEXCOORD0;

};

VS_OUTPUT VS(
    float4 Pos  : POSITION,
    float3 NormO : NORMAL,
    float4 TexC : TEXCOORD)
{
    //inititalize all fields of output struct with 0
    VS_OUTPUT Out = (VS_OUTPUT)0;
    

    
    //transform texturecoordinates
    tTex = mul (RCtoTC, tTex   );
    TexC = Pos;
    
    TexC = mul(TexC, tW);
    TexC = mul(TexC, tTex);
    
    Out.TexC = TexC;
    

    //transform position
    Pos = mul(Pos, tWVP);

    Out.PosWVP  = Pos;

    return Out;
}

// -------------------------------------------------------------------------------------------------------------------------------------
// PIXELSHADERS:
// -------------------------------------------------------------------------------------------------------------------------------------

float4 PS(VS_OUTPUT In): COLOR
{
    float4 col = tex2Dproj(Samp, In.TexC);
    Dist += 1;
    

    //if( TexC.w>0.0 )          normalize    // if( In.TexC.z > 0 && In.TexC.z < Dist && In.TexC.z > In.CheckPos.z )
    if( In.TexC.z > 0 && In.TexC.z < Dist )
    {
    In.TexC.xyz =  (In.TexC.xyz / (In.TexC.w));

    col.a = Alpha;
    
    }
    else col = 0;
    
    // below: kill all color outside of original texture.
    if(     In.TexC.x < 0 || In.TexC.y < 0

         || In.TexC.x > 1 || In.TexC.y > 1 )      //|| In.TexC.w > Dist
    {
    col = 0;
    }
    //col.rgb *= In.Diffuse;
    return col;
}

// -------------------------------------------------------------------------------------------------------------------------------------
// TECHNIQUES:
// -------------------------------------------------------------------------------------------------------------------------------------

technique TSimpleShader
{
    pass P0
    {

       // TextureTransformFlags[0] = COUNT3 | PROJECTED;
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}
